/*
 * (c) 2007 by Matthijs Mekking / NLnet Labs
 *
 * SHIM6 Library Header Files
 *
 */

#ifndef _SIM_SHIM6_H

#define _SIM_SHIM6_H

/* SHIM6 control message types */
#define SHIM6_TYPE_I1           0x01    /* 0 000 0001 */
#define SHIM6_TYPE_R1           0x02    /* 0 000 0010 */
#define SHIM6_TYPE_I2           0x03    /* 0 000 0011 */
#define SHIM6_TYPE_R2           0x04    /* 0 000 0100 */
#define SHIM6_TYPE_R1BIS        0x05    /* 0 000 0101 */
#define SHIM6_TYPE_I2BIS        0x06    /* 0 000 0110 */
#define SHIM6_TYPE_UPDACK       0x40    /* 0 100 0000 = 64 */
#define SHIM6_TYPE_UPDREQ       0x41    /* 0 100 0001 = 65 */
#define SHIM6_TYPE_KEEPALIVE    0x42    /* 0 100 0010 = 66 */
#define SHIM6_TYPE_PROBE        0x43    /* 0 100 0011 = 67 */

/* SHIM6 Bitmasks */
#define SHIM6_BITMASK_P         0x80    /* 1 000 0000 */
#define SHIM6_BITMASK_TYPE      0x7F    /* 0 111 1111 */
#define SHIM6_BITMASK_PROTOCOL  0x01    /* 0 000 0001 */
#define SHIM6_BITMASK_SPECIFIC  0xFE    /* 1 111 1110 */
#define SHIM6_BITMASK_R         0x80    /* 1 000 0000 */
#define SHIM6_BITMASK_CT        0x7F    /* 0 111 1111 */

/* SHIM6 Options */
#define SHIM6_OPT_RESPVAL	0x01    /* 0 000 0001 */
#define SHIM6_OPT_LOCLIST	0x02    /* 0 000 0010 */
#define SHIM6_OPT_LOCPREF	0x03    /* 0 000 0011 */
#define SHIM6_OPT_CGAPDM	0x04    /* 0 000 0100 */
#define SHIM6_OPT_CGASIG	0x05    /* 0 000 0101 */
#define SHIM6_OPT_ULIDPAIR	0x06    /* 0 000 0110 */
#define SHIM6_OPT_FII		0x07    /* 0 000 0111 */

#define SHIM6_OPT_ILLEGAL	0x0F    /* 0 000 1111 */

/* Other settings */

#define CRITICAL		1
#define HZ			1
#define VALIDATOR_MIN_LIFETIME	45*HZ

#define SHIM6_VERIF_HBA		0x01	/* 0 000 0001 */
#define SHIM6_VERIF_CGA		0x02	/* 0 000 0010 */

#define SHIM6_PREF_BROKEN	0x01    /* 0 000 0001 */
#define SHIM6_PREF_TEMPORARY	0x02    /* 0 000 0010 */

#define I1_RETRIES_MAX		   4
#define I2_RETRIES_MAX		   2
#define I2BIS_RETRIES_MAX	   2

/* SHIM6 REAP States */

#define SHIM6_REAP_OPERATIONAL  0x00    /* 0 000 0000 */
#define SHIM6_REAP_EXPLORING    0x01    /* 0 000 0001 */
#define SHIM6_REAP_INBOUNDOK    0x02    /* 0 000 0010 */

/* structs */

struct shim_loc_list {
	unsigned char *locator;
	unsigned char verif_method;
	int flag;
	int priority;
	int weight;
	struct shim_loc_list *next;
};

struct shim_probe_list {
	char *source;
	char *destination;
	char *nonce;
	char *data;
	struct shim_probe_list *next;
};

/* value to string */
typedef struct {
  	int value;
	const char *strptr;
} value_string;

/* function calls */
extern int sim_print_shim6(unsigned char *pkt);
extern const char *val_to_str(int value, const value_string *vs);

/* payload */
extern int sim_add_dummytcp(unsigned char *pkt, int *pkt_len, unsigned char *data, int len);
extern int sim_add_payload(unsigned char *pkt, int *pkt_len, unsigned char *ct);

/* options */
extern int sim_add_opts(unsigned char *pkt, int *pkt_len, unsigned char type, int c, int len, unsigned char *contents); 
extern int sim_add_opts_respval(unsigned char *pkt, int *pkt_len, int c, unsigned char *val, int len);
extern int sim_add_opts_loclist(unsigned char *pkt, int *pkt_len, int c, unsigned char *llg, struct shim_loc_list *list);
extern int sim_add_opts_locpref(unsigned char *pkt, int *pkt_len, int c, unsigned char *llg, int ellen, struct shim_loc_list *list);
extern int sim_add_opts_cgapdm(unsigned char *pkt, int *pkt_len, int c, unsigned char *pdm, int len);
extern int sim_add_opts_cgasig(unsigned char *pkt, int *pkt_len, int c, unsigned char *sig, int len);
extern int sim_add_opts_ulidpair(unsigned char *pkt, int *pkt_len, int c, unsigned char *snd, unsigned char *rcv);
extern int sim_add_opts_fii(unsigned char *pkt, int *pkt_len, int c, unsigned char *fii);
extern int sim_add_opts_illegal(unsigned char *pkt, int *pkt_len, int c, unsigned char *illegal, int len);

/* control messages */
extern int sim_add_control(unsigned char *pkt, int *pkt_len, unsigned char type, unsigned char *buf2, int len);
extern int sim_add_control_i1(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *nonce, int len);
extern int sim_add_control_r1(unsigned char *pkt, int *pkt_len, unsigned char *nonce, unsigned char *nonce2, int len);
extern int sim_add_control_i2(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *nonce, unsigned char *nonce2, int len);
extern int sim_add_control_r2(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *nonce, int len);
extern int sim_add_control_r1bis(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *nonce, int len);
extern int sim_add_control_i2bis(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *ct2, unsigned char *nonce, unsigned char *nonce2, int len);
extern int sim_add_control_updreq(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *nonce, int len);
extern int sim_add_control_updack(unsigned char *pkt, int *pkt_len, unsigned char *ct, unsigned char *nonce, int len);
extern int sim_add_control_keepalive(unsigned char *pkt, int *pkt_len, unsigned char *ct);
extern int sim_add_control_probe(unsigned char *pkt, int *pkt_len, unsigned char *ct, int sta, struct shim_probe_list *recvd, struct shim_probe_list *sent);

#endif

