/*
 * (c) 2007 by Matthijs Mekking / NLnet Labs
 *
 * SHIM6 Context Library
 *
 */

#ifndef _SIM_SHIM6_C

#define _SIM_SHIM6_C

#include "sim-shim6.h"

/* SHIM6 control message types */
#define SHIM6_STATE_IDLE        0x01    /* 0 000 0001 */
#define SHIM6_STATE_I1SENT      0x02    /* 0 000 0010 */
#define SHIM6_STATE_I2SENT      0x03    /* 0 000 0011 */
#define SHIM6_STATE_ESTABLISHED 0x04    /* 0 000 0100 */
#define SHIM6_STATE_I2BISSENT   0x05    /* 0 000 0101 */
#define SHIM6_STATE_EFAILED     0x06    /* 0 000 0110 */
#define SHIM6_STATE_NOSUPPORT   0x07    /* 0 000 0111 */

#define REAP_STATE_OPERATIONAL  0x00    /* 0 000 0000 */
#define REAP_STATE_EXPLORING    0x01    /* 0 000 0001 */
#define REAP_STATE_INBOUNDOK    0x02    /* 0 000 0010 */

/* structs */

struct shim_ctx {
	int cstate;
	unsigned char *cpeerulid;
	unsigned char *clocalulid;
	unsigned char *cfii;

	unsigned char *cpeerlp;
	unsigned char *clocallp;

	struct shim_loc_list *cpeerls;
	struct shim_loc_list *clocalls;
	unsigned char *cpeerlistgen;
	unsigned char *clocallistgen;

	unsigned char *cpeertag;
	unsigned char *clocaltag;
	unsigned char *cnonceinit;
	unsigned char *cnonceresp;
	unsigned char *crespval;
	int crespvallen;

	/* REAP */
	int rstate;
	struct shim_probe_list *rsent;
	struct shim_probe_list *rrecvd;
};

#endif

