/*
 *  shimulator: A SHIM6 Simulator at user level
 *  Matthijs Mekking (c) 2007
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/wait.h>
#include <time.h>
#include <pcap.h>
#include "thc-ipv6.h"
#include "sim-shim6.h"
#include "sim-ctx.h"

/* debugging */
extern int debug;
extern int sim_debug;

/* global variables */
unsigned char *pkt = NULL;
int pkt_len = 0;
thc_ipv6_hdr *ipv6;
char *interface;
char *multicast = "ff020000000000000000000000000001";
char *spoof = "2001000000000000020c29fffeb97f80";
int debgu;

/* shim6 variables */
struct shim_loc_list *top = NULL; 
struct shim_loc_list *stack = NULL; 

/* HELP FUNCTIONS */

void add_locator(unsigned char *ulid_local) {
  if (stack == NULL) {
	struct shim_loc_list *new_locator; 
	new_locator = (struct shim_loc_list *) malloc(sizeof(struct shim_loc_list));
	new_locator->locator = ulid_local;
	new_locator->verif_method = 0; 
	new_locator->flag = 0; 
	new_locator->priority = 1; 
	new_locator->weight = 2; 
  	new_locator->next = NULL;
		  
	stack = new_locator;
	top = stack;
  }
  else {
 	struct shim_loc_list *new_locator; 
	new_locator = (struct shim_loc_list *) malloc(sizeof(struct shim_loc_list));
	new_locator->locator = ulid_local;
	new_locator->verif_method = 0; 
	new_locator->flag = 0;
	new_locator->priority = 2;
	new_locator->weight = 1;
  	new_locator->next = NULL;

	top->next = new_locator;
	top = new_locator;
  }
  return;
}

/* PRINT FUNCTIONS */

int help(char *prg) {
  printf("USAGE\n");
  printf("      %s -send <msgtype> <destination> <interfaces> [options]\n", prg);
  printf("      %s -help\n\n", prg);
  printf("DESCRIPTION\n");
  printf("     sends SHIM6 messages of <msgtype> to <destination> using the first of <interfaces>\n");
  printf("OPTIONS\n");
  printf("-r[c]\n"); 
  printf("     add responder validator, add c to make option critical\n");
  printf("-l[c]\n");
  printf("     add locator list\n");
  printf("     if -p option is given, locator preferences with an element length of <len> are also added\n");
  printf("-p[c] <len> <interfaces>\n");
  printf("     add locator preferences of <interfaces> with an element length of <len>\n");
  printf("-cga[c]\n");
  printf("     add (dummy) cga parameter data structure\n");
  printf("-sig[c]\n");
  printf("     add (dummy) cga signature\n");
  printf("-u[c] <interface> <dst>\n");
  printf("     use (addres of <interface>, <dst>) as ulid pair\n");
  printf("-f[c]\n");
  printf("     add forked instance identifier\n");
  printf("-i[c]\n");
  printf("     add an illegal option\n\n");
  return 1;
}

/* MAIN PROGRAM */

int main(int argc, char **argv) {
  char *my_ipv6;
  char *dst; 
  char *ct1;
  char *ct2;
  char *nonce1;
  char *nonce2;
  
  int i, j, sta, critical, ulid;

  struct shim_probe_list *next_probe; 
  struct shim_probe_list *recvd; 
  struct shim_probe_list *sent; 
	
  /* respval */  
  char *respval;
  /* locator list */
  char *loclistgen;
  /* locator preferences */
  int elemlen;
  /* cga parameter data structure */
  char *cgapdm;
  /* cga signature */
  char *cgasig;
  /* ulid pair */
  char *ulid_local; 
  char *ulid_peer; 
  /* fii */
  char *fii;
  /* illegal option */
  char *illegal;  

  /* print tool information */
  fprintf(stdout, "Shimulator: A User Level SHIM6 Simulater (c) 2007\n\n"); 

  /* parse options */
  if (argc < 2) {
	return help(argv[0]);
  }
  else if (strncmp(argv[1], "-help", 5) == 0) {
	return help(argv[0]); 
  }
  else if (strncmp(argv[1], "-send", 5) == 0) {
    if (argc < 5) {
      fprintf(stdout, "Usage: %s -send <msgtype> <destination> <interface> [options]\n", argv[0]);
      fprintf(stdout, "Run '%s -help' for more information\n", argv[0]);
      return -1;
    }       

    interface = argv[4]; /* first interface */
    dst = thc_resolve6(argv[3]);
    my_ipv6 = thc_get_own_ipv6(interface, dst, PREFER_GLOBAL);
  
    ct1 = malloc(6);
    ct2 = malloc(6);
    for (j=0; j<6; j++) {
 	ct1[j] = rand()*4;
 	ct2[j] = rand();
    }

    nonce1 = malloc(4);
    nonce2 = malloc(4);
    for (j=0; j<4; j++) {
 	nonce1[j] = rand();
 	nonce2[j] = rand();
    }

    loclistgen = malloc(4); 
    for (j=0; j<4; j++)
	  loclistgen[j] = rand();

    /* create IPv6 packet */
    if ((pkt = (unsigned char *) thc_create_ipv6(interface, PREFER_GLOBAL, &pkt_len, 
		(unsigned char *) my_ipv6, (unsigned char *) dst, 
		255, 0, 0, 0, 0)) == NULL) {
      fprintf(stdout, "Cannot create IPv6 packet. Possible illegal interface or destination.\n"); 
      return -1;  
    }

    /* multicast */

    /*
    if ((pkt = (unsigned char *) thc_create_ipv6(interface, PREFER_GLOBAL, &pkt_len, 
		(unsigned char *) thc_string2ipv6(multicast), (unsigned char *) dst,
		// (unsigned char *) my_ipv6, (unsigned char *) thc_string2ipv6(multicast), 
		255, 0, 0, 0, 0)) == NULL) {
      fprintf(stdout, "Cannot create IPv6 packet. Possible illegal interface or destination.\n"); 
      return -1;  
    }
    */

    /* add shim6 extension header */
    if (strncmp(argv[2], "R1bis", 5) == 0) {
	sim_add_control_r1bis(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) nonce1, 10);
    }
    else if (strncmp(argv[2], "I2bis", 5) == 0) {
	sim_add_control_i2bis(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) ct2, 
		(unsigned char *) nonce1, (unsigned char *) nonce2, 26);
    }
    else if (strncmp(argv[2], "I1", 2) == 0) {
	sim_add_control_i1(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) nonce1, 10);
    }
    else if (strncmp(argv[2], "R1", 2) == 0) {
	sim_add_control_r1(pkt, &pkt_len, (unsigned char *) nonce1, (unsigned char *) nonce2, 10);
    }
    else if (strncmp(argv[2], "I2", 2) == 0) {
	sim_add_control_i2(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) nonce1, 
		(unsigned char *) nonce2, 18);
    }
    else if (strncmp(argv[2], "R2", 2) == 0) {
	sim_add_control_r2(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) nonce1, 10);
    }
    else if (strncmp(argv[2], "UR", 2) == 0) {
	sim_add_control_updreq(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) nonce1, 10);
    }
    else if (strncmp(argv[2], "UA", 2) == 0) {
	sim_add_control_updack(pkt, &pkt_len, (unsigned char *) ct1, (unsigned char *) nonce1, 10);
    }
    else if (strncmp(argv[2], "K", 1) == 0) {
	sim_add_control_keepalive(pkt, &pkt_len, (unsigned char *) ct1);
    }
    else if (strncmp(argv[2], "P", 1) == 0) {
	sim_add_control_probe(pkt, &pkt_len, (unsigned char *) ct1, sta, 
		(struct shim_probe_list *) recvd, (struct shim_probe_list *) sent); 
    }
    else {
	fprintf(stdout, "Illegal message type. Valid message types are:\n");
	fprintf(stdout, "I1, R1, I2, R2, R1bis, I2bis, UR, UA, K, P\n"); 
	return -1;
    }

    /* locator list */
    i = 4; 
    while (i<argc) {
	if (strncmp(argv[i], "-", 1) == 0) {
	  /* to options */
	  break;
        }
		
	/* add locator */
	ulid_local = malloc(16);
	ulid_local = thc_get_own_ipv6(argv[i], dst, PREFER_GLOBAL);

	add_locator((unsigned char *) ulid_local);
		
	i++;
    }

    /* spoofed locators */
    /*
    add_locator((unsigned char *) multicast);
    add_locator((unsigned char *) spoof);
    */
  
    /* options */
    ulid = 0;
    while (i < argc) {
	if (strncmp(argv[i], "-cga", 4) == 0) {
	  if (strncmp(argv[i], "-cgac", 5) == 0) 
		critical = 1;
	  else
		critical = 0;

	  cgapdm = malloc(8); /* just a dummy length */ 
	  for (j=0; j<8; j++)
		  cgapdm[j] = rand();
	  sim_add_opts_cgapdm(pkt, &pkt_len, critical, (unsigned char *) cgapdm, 8); 
	  i++;
	} else if (strncmp(argv[i], "-sig", 4) == 0) {
	  if (strncmp(argv[i], "-sigc", 5) == 0) 
		critical = 1;
	  else
		critical = 0;

	  cgasig = malloc(8); /* just a dummy length */ 
	  for (j=0; j<8; j++)
		  cgasig[j] = rand();
	  sim_add_opts_cgasig(pkt, &pkt_len, critical, (unsigned char *) cgasig, 8); 
	  i++;
	} else if (strncmp(argv[i], "-r", 2) == 0) {
	  if (strncmp(argv[i], "-rc", 3) == 0) 
		critical = 1;
	  else
		critical = 0;

	  respval = malloc(13); /* just a dummy length */ 
	  for (j=0; j<13; j++)
		  respval[j] = rand();
	  sim_add_opts_respval(pkt, &pkt_len, critical, (unsigned char *) respval, 13); 
	  i++;

	} else if (strncmp(argv[i], "-l", 2) == 0) {

	  if (strncmp(argv[i], "-lc", 3) == 0) 
		critical = 1;
	  else
		critical = 0;

	  sim_add_opts_loclist(pkt, &pkt_len, critical, (unsigned char *) loclistgen, (struct shim_loc_list *) stack);
	  i++;	  
	}
	else if (strncmp(argv[i], "-p", 2) == 0) {
	  if (strncmp(argv[i], "-pc", 3) == 0) 
		critical = 1;
	  else
		critical = 0;
	  i++;
	  elemlen = atoi(argv[i]);

    	  sim_add_opts_locpref(pkt, &pkt_len, critical, (unsigned char *) loclistgen, elemlen, (struct shim_loc_list *) stack);
	  i++;
	}
	else if (strncmp(argv[i], "-u", 2) == 0) {
	  ulid = 1;

	  if (strncmp(argv[i], "-uc", 3) == 0) 
		critical = 1;
	  else
		critical = 0;
	  i++;
	  ulid_local = thc_get_own_ipv6(argv[i], dst, PREFER_GLOBAL);
	  i++;
	  ulid_peer = thc_resolve6(argv[i]);
	 
    	  sim_add_opts_ulidpair(pkt, &pkt_len, critical, (unsigned char *) ulid_local, (unsigned char *) ulid_peer);	  
	  i++;
	}
	else if (strncmp(argv[i], "-f", 2) == 0) {
	  if (strncmp(argv[i], "-fc", 3) == 0) 
		critical = 1;
	  else
		critical = 0;
	  fii = malloc(4); 
	  for (j=0; j<4; j++)
		  fii[j] = rand();
	  sim_add_opts_fii(pkt, &pkt_len, critical, (unsigned char *) fii); 
	  i++;
	}
	else if (strncmp(argv[i], "-i", 2) == 0) {
	  if (strncmp(argv[i], "-ic", 3) == 0) 
		critical = 1;
	  else
		critical = 0;
	  illegal = malloc(4); 
	  for (j=0; j<4; j++)
		  illegal[j] = rand();
	  sim_add_opts_illegal(pkt, &pkt_len, critical, (unsigned char *) illegal, 4); 
	  i++;
	}
	else { 
  	  fprintf(stdout, "Illegal option %s.\n", argv[i]);
      	  fprintf(stdout, "run '%s -help' for more information\n", argv[0]);
	  return -1;
 	} 
    }

    /* send packet */
    if (thc_generate_and_send_pkt(interface, NULL, NULL, pkt, &pkt_len) < 0) {
      fprintf(stdout, "Generating and sending packet failed\n");
      return -1;
    }

    fprintf(stdout, "SHIM6 packet succesfully transmitted\n");
    return 1;
  }

}
